<?php
  // This test simulates real-life situation:
  //   {{TOC}} ... {{If format=html; Include footer.html}}
  // Include's priority is higher than TOC's; normally both Include & TOC are static but since Include
  // depends on dynamic If action it becomes dynamic; so does TOC. WHen rendering, Include must be
  // called before TOC so that headings from the included document are included in common TOC.

class Utfpdynamic_Root extends UWikiBaseAction {
  function IsDynamic($format, $params) { return true; }
  function Execute($format, $params) { ++$GLOBALS['tfpParseCounts']['dynamic']; }
}

class Utfphighpriority_Root extends UWikiBaseAction {
  function Priority($format, $params) { return (int) UWikiMaxPriority * 0.7; }
  function Execute($format, $params) { ++$GLOBALS['tfpParseCounts']['high']; }
}

class Utfpdynalowpriority_Root extends UWikiBaseAction {
  function IsDynamic($format, $params) { return true; }
  function Priority($format, $params) { return (int) UWikiMaxPriority * 0.3; }

  function Execute($format, $params) {
    global $tfpParseCounts;
    ++$tfpParseCounts['lowdyna'];

    TestThat($tfpParseCounts['dynamic'] === 1);
    TestThat($tfpParseCounts['high'] === 1);
  }
}


  $src = '
%%(tfpDynalowpriority)
z
%%
%%(tfpDynamic; tfpHighpriority)
z
%%
';
  $doc = new UWikiDocument($src);
  $doc->settings = $settings;
  $doc->LoadMarkup('wacko');

  global $tfpParseCounts;

    $tfpParseCounts = array('dynamic' => 0, 'high' => 0, 'lowdyna' => 0);
      $doc->Parse();
    TestThat( $tfpParseCounts === array('dynamic' => 0, 'high' => 0, 'lowdyna' => 0) );

    $tfpParseCounts = array('dynamic' => 0, 'high' => 0, 'lowdyna' => 0);
      $doc->ToHTML();
    TestThat( $tfpParseCounts === array('dynamic' => 1, 'high' => 1, 'lowdyna' => 1) );
